import React, { useEffect, useState } from "react";

const ModalUsers = React.memo(({ empresaSeleccionada, onClose }) => {
  const closeModal = () => {
    onClose();
  };

  const [usuarios, setUsuarios] = useState([]);

  useEffect(() => {
    // Simulación de datos de usuarios (reemplaza con la lógica de obtención real)
    const usuariosData = {
      "001": [
        {
          usuario_id: "001",
          nombre_usuario: "Felipe",
          rut_usuario: "20.342.532-1",
          correo_usuario: "f@gmail.com",
          telefono_usuario: "987665336",
        },
        {
          usuario_id: "002",
          nombre_usuario: "Tomas",
          rut_usuario: "21.312.332-2",
          correo_usuario: "toma@mail.com",
          telefono_usuario: "987654321",
        },
      ],
      "002": [
        {
          usuario_id: "003",
          nombre_usuario: "Maria",
          rut_usuario: "21.312.332-2",
          correo_usuario: "maria@gmail.com",
          telefono_usuario: "923246574",
        },
        {
          usuario_id: "004",
          nombre_usuario: "Camila",
          rut_usuario: "20.342.532-1",
          correo_usuario: "camila@mail.com",
          telefono_usuario: "923246574",
        },
        {
          usuario_id: "004",
          nombre_usuario: "Camila",
          rut_usuario: "20.342.532-1",
          correo_usuario: "camila@mail.com",
          telefono_usuario: "923246574",
        },
        {
          usuario_id: "004",
          nombre_usuario: "Camila",
          rut_usuario: "20.342.532-1",
          correo_usuario: "camila@mail.com",
          telefono_usuario: "923246574",
        },
        {
          usuario_id: "004",
          nombre_usuario: "Camila",
          rut_usuario: "20.342.532-1",
          correo_usuario: "camila@mail.com",
          telefono_usuario: "923246574",
        },
        {
          usuario_id: "004",
          nombre_usuario: "Camila",
          rut_usuario: "20.342.532-1",
          correo_usuario: "camila@mail.com",
          telefono_usuario: "923246574",
        },
        {
          usuario_id: "004",
          nombre_usuario: "Camila",
          rut_usuario: "20.342.532-1",
          correo_usuario: "camila@mail.com",
          telefono_usuario: "923246574",
        },
        {
          usuario_id: "004",
          nombre_usuario: "Camila",
          rut_usuario: "20.342.532-1",
          correo_usuario: "camila@mail.com",
          telefono_usuario: "923246574",
        },
        {
          usuario_id: "004",
          nombre_usuario: "Camila",
          rut_usuario: "20.342.532-1",
          correo_usuario: "camila@mail.com",
          telefono_usuario: "923246574",
        },
        {
          usuario_id: "004",
          nombre_usuario: "Camila",
          rut_usuario: "20.342.532-1",
          correo_usuario: "camila@mail.com",
          telefono_usuario: "923246574",
        },
        {
          usuario_id: "004",
          nombre_usuario: "Camila",
          rut_usuario: "20.342.532-1",
          correo_usuario: "camila@mail.com",
          telefono_usuario: "923246574",
        },
        {
          usuario_id: "004",
          nombre_usuario: "Camila",
          rut_usuario: "20.342.532-1",
          correo_usuario: "camila@mail.com",
          telefono_usuario: "923246574",
        },
      ],
    };

    // Obtén los usuarios correspondientes a la empresa seleccionada
    const usuariosEmpresa = empresaSeleccionada
      ? usuariosData[empresaSeleccionada.empresa_id] || []
      : [];

    // Actualiza el estado 'usuarios' con los datos obtenidos
    setUsuarios(usuariosEmpresa);
  }, [empresaSeleccionada]);

  return (
    <div className="overflow-auto max-h-[80vh] max-w-7xl p-1">
      <div className="text-black w-2/3 border-b border-black mb-4">
        <h2 className="text-black text-2xl font-bold mb-[1px] ml-1">
          Usuarios de {empresaSeleccionada.nombre_empresa}
        </h2>
      </div>

      <table className="min-w-full divide-y divide-gray-200">
        <thead className="bg-gray-50">
          <tr>
            <th
              scope="col"
              className="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider"
            >
              Nombre
            </th>
            <th
              scope="col"
              className="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider"
            >
              Rut
            </th>
            <th
              scope="col"
              className="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider"
            >
              Correo
            </th>
            <th
              scope="col"
              className="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider"
            >
              Teléfono
            </th>
          </tr>
        </thead>
        <tbody className="bg-white divide-y divide-gray-200 text-black">
          {usuarios.map((usuario) => (
            <tr key={usuario.usuario_id}>
              <td className="px-6 py-4 whitespace-nowrap">
                {usuario.nombre_usuario}
              </td>
              <td className="px-6 py-4 whitespace-nowrap">
                {usuario.rut_usuario}
              </td>
              <td className="px-6 py-4 whitespace-nowrap">
                {usuario.correo_usuario}
              </td>
              <td className="px-6 py-4 whitespace-nowrap">
                {usuario.telefono_usuario}
              </td>
            </tr>
          ))}
        </tbody>
      </table>

      <div className="mt-2 text-right">
        <button
          className="bg-gray-500 hover:bg-gray-600 text-white px-4 py-2 rounded-lg"
          onClick={closeModal}
        >
          Cancelar
        </button>
      </div>
    </div>
  );
});

ModalUsers.displayName = "ModalUsers"
export default ModalUsers;
