"use client"
import { useState, useEffect } from "react";
import { FaBuilding } from "react-icons/fa";
import { useSession } from "@/app/contexts/SessionContext";

const EmpresaCard = () => {
  // Puedes manejar el estado del icono aquí si es necesario
  const { user } = useSession();
  const [isOpen, setIsOpen] = useState(false);
  const [empresas, setEmpresas] = useState([]); // Tu lista de empresas
  const [empresaSelected, setEmpresaSelected] = useState({});

  useEffect(() => {

    if (user) {
      console.log(user)
      const usuario = user.usuario
      const datosEmpresas = usuario.empresas;
      setEmpresas(datosEmpresas);
    }

    const empresaSelected = localStorage.getItem("empresaData");

    if (empresaSelected) {
      const datosEmpresa = JSON.parse(empresaSelected);
      setEmpresaSelected(datosEmpresa);
    } else {
      const datosUsuario = JSON.parse(user);
      setEmpresaSelected(datosUsuario.empresas[0]);
    }
  }, []);

  const toggleDropdown = () => {
    setIsOpen(!isOpen);
  };

  const handleEmpresaSelectorClick = (item_id) => {
    const selected = empresas.find((item) => item.empresa_id == item_id);

    setEmpresaSelected(selected);
    localStorage.setItem("empresaData", JSON.stringify(selected));
    setIsOpen(false);
  };

  return (
    <div className="relative w-auto">
      <button
        className="py-2 px-3 bg-[#242745] text-white rounded-md shadow-md cursor-pointer"
        onClick={toggleDropdown}
      >
        <div className="flex items-center">
          <FaBuilding size={32} className="hover:text-slate-300" />
          <div className="ml-2">
            <p className="font-bold translate-y-1 capitalize">
              {empresaSelected.nombre_empresa}
            </p>
            <p className="capitalize text-sm font-medium text-slate-500">
              Empresa
            </p>
          </div>
        </div>
      </button>
      {isOpen && (
        <div className="fixed grid grid-cols-1 bg-[#2d3253] text-slate-200 rounded-md shadow-md text-left w-auto">
          {/* Dropdown items */}
          {empresas.map((empresa) => (
            <button
              key={empresa.empresa_id}
              className="p-2 hover:bg-[#353a58]"
              onClick={() => handleEmpresaSelectorClick(empresa.empresa_id)}
            >
              {empresa.nombre_empresa}
            </button>
          ))}

          {/* Add more items as needed */}
        </div>
      )}
    </div>
  );
};

export default EmpresaCard;
