import React from 'react';

const Alert = ({ onClose, type, className, children }) => {
  // Definir clases de Tailwind según el tipo de alerta
  const alertClasses = {
    primary: 'bg-blue-500 text-white',
    secondary: 'bg-gray-500 text-white',
    success: 'bg-green-500 text-white',
    danger: 'bg-red-500 text-white',
    info: 'bg-blue-300 text-black',
    warning: 'bg-yellow-500 text-black',
  }[type] || '';

  return (
    <div className={`rounded-md p-4 ${alertClasses} ${className}`}>
      <div className="flex justify-between items-center">
        <div className="flex items-center">
          <span className="mr-2">{children}</span>
        </div>
        {onClose && (
          <button
            onClick={onClose}
            className="text-white hover:text-gray-200 focus:outline-none focus:text-gray-200"
          >
            X
          </button>
        )}
      </div>
    </div>
  );
};

export default Alert;