import React, { useState } from 'react'
import { IoMdDownload } from 'react-icons/io'

const HistoryCard = ({ data }) => {
  const [mostrarMas, setMostrarMas] = useState(false)

  const {
    Institución: institucion,
    ID: id,
    Proyecto: proyecto,
    fecha_subida,
    fecha_postulacion,
    estado,
  } = data

  const handleDescargarPDF = () => {
    // Lógica para descargar el PDF
  }

  return (
    <div className='border border-[#073673] p-4 rounded-md mx-4 bg-[#07338C] my-4 relative'>
      <div className='flex flex-col'>
        <p>
          <strong>Institución:</strong> {institucion}
        </p>
        <p>
          <strong>ID:</strong> {id}
        </p>
        <p>
          <strong>Proyecto:</strong> {proyecto}
        </p>
        <p>
          <strong>Fecha de Subida:</strong> {fecha_subida}
        </p>
        <p>
          <strong>Fecha de Postulación:</strong> {fecha_postulacion}
        </p>
        <p>
          <strong>Estado:</strong> {estado}
        </p>
        <div className='md:hidden'>
          {/* El botón estará debajo del último texto en pantallas pequeñas */}
          <button
            className='bg-red-500 hover:bg-red-700 text-white font-bold py-2 px-4 rounded flex items-center mt-2'
            onClick={handleDescargarPDF}
          >
            <IoMdDownload className='mr-2' size={20} />
            Descargar PDF
          </button>
        </div>
      </div>
      <div className='hidden md:block absolute bottom-4 right-4'>
        {/* El botón estará en la esquina inferior derecha en pantallas medianas y grandes */}
        <button
          className='bg-red-500 hover:bg-red-700 text-white font-bold py-2 px-4 rounded flex items-center'
          onClick={handleDescargarPDF}
        >
          <IoMdDownload className='mr-2' size={20} />
          Descargar PDF
        </button>
      </div>
    </div>
  )
}

export default HistoryCard
