"use client"
import React, { useState, useEffect } from 'react';
import { Cog6ToothIcon } from '@heroicons/react/24/solid';

const Configuracion = () => {

  const [empresas, setEmpresas] = useState([]);// Tu lista de empresas
  const [empresaSeleccionada, setEmpresaSeleccionada] = useState(''); //captura la empresa por su id

  useEffect(() => {
    // Realizar la solicitud HTTP al back-end
    const user = localStorage.getItem("userData")

    if(user){
      const datosUsuario = JSON.parse(user)

      setEmpresas(datosUsuario.empresas)
    }

    }, []);
  
  // Manejar cambios en la selección de empresa
  const handleEmpresaChange = (e) => {
    setEmpresaSeleccionada(e.target.value);
  };

  // Manejar clic en el botón "Aplicar"
  const handleAplicarClick = () => {
    // Aquí puedes realizar la lógica para exportar el ID de la empresa
    console.log('ID de la empresa seleccionada:', empresaSeleccionada);
  };

  return (
    <section>
      <div>
      <div className="rounded-md py-4 max-w-sm md:max-w-md lg:max-w-lg xl:max-w-xl">
              <h1 className="flex items-center text-3xl font-bold text-black border-b border-black pb-2">
                <Cog6ToothIcon className='h-8 w-8 mr-2'/>
                Configuracion
              </h1>
      </div>


          </div>
          <div className='flex justify-center items-center mt-8'>
            <div className='w-[90%] sm:w-[80%] md:w-1/2 lg:w-1/3'>
              <div className='bg-[#242745] rounded p-6 shadow-xl'>
                <div className='mb-4'>
                  <div className='items-center'>

                    <div>
                      <h2 className='text-xl font-semibold mb-5 w-2/4'>Seleccionar empresa</h2>
                    </div>
                    
                    <div>
                      <select
                        id='empresas'
                        value={empresaSeleccionada}
                        onChange={handleEmpresaChange}
                        className='border border-gray-300 px-2 py-1 rounded w-100 text-black'
                      >
                        {empresas.map((empresas) => (
                          <option key={empresas.empresa_id} value={empresas.empresa_id}>
                            {empresas.nombre_empresa} 
                          </option>
                        ))}
                      </select>
                    </div>
                  </div>
                  <div className='flex justify-center mt-4'>
                  <button
                    className='bg-blue-700 hover:bg-blue-900 text-white font-bold py-2 px-4 rounded'
                    onClick={handleAplicarClick}
                  >
                    Aplicar
                  </button>
                </div>
                </div>
              </div>
            </div>
          </div>
      </section>
  );
};

export default Configuracion;
