"use client";

import { useState } from "react";
import LoadingSpinner from "../../components/loadingSpinner";
import { API_URL } from "@/app/const";

export default function OtecToolsDashboard() {
  const [loading, setLoading] = useState(false);

  const handleGenerarZipFileChange = (event) => {

    const today = new Date();
    const zip_filename = `${today.getDate()}-${today.getMonth() + 1}-${today.getFullYear()}_COMPRAAGIL_OTEC.zip`;
    handleUpload(event.target.files[0], "/capacitacionesOtec/otecpdf/", zip_filename);

  };

  const handleGenerarZipIAFileChange = (event) => {

    const today = new Date();
    const zip_filename = `${today.getDate()}-${today.getMonth() + 1}-${today.getFullYear()}_LICITACION_OTEC.zip`;
    handleUpload(event.target.files[0], "/capacitacionesOtec/otecpdfia/", zip_filename);
  };

  const handleUpload = async (file, url, fileName) => {
    if (!file) {
      alert("Please select a file");
      return;
    }

    const formData = new FormData();
    formData.append("file", file);

    try {
      setLoading(true);
      const response = await fetch(
        API_URL + url,
        {
          method: "POST",
          body: formData,
        }
      );

      if (response.ok) {
        const data = await response.blob();
        const downloadUrl = window.URL.createObjectURL(data);
        const link = document.createElement("a");

        link.href = downloadUrl;
        link.setAttribute("download", fileName);
        document.body.appendChild(link);
        link.click();
        link.parentNode.removeChild(link);
      } else {
        alert("Error uploading file");
      }

      setLoading(false);
    } catch (error) {
      console.error("Error uploading file:", error);
      alert("Error uploading file");
      setLoading(false);
    }
  };

  return (
    <section className="text-center">
      <div className="text-2xl">Herramientas OTEC</div>

      <div className="flex gap-4 mt-4">
        <button
          onClick={() => document.getElementById("generarZipFile").click()}
          className="py-8 px-12 bg-indigo-400 text-black rounded-lg shadow-md hover:bg-indigo-200"
        >
          <p className="text-xl text-slate-800">Generar ZIP</p>
          <p className="text-sm text-slate-600">Compras Ágiles</p>

          <input
            id="generarZipFile"
            type="file"
            style={{ display: "none" }}
            onChange={handleGenerarZipIAFileChange}
          />
        </button>

        <button
          onClick={() => document.getElementById("generarIAZipFile").click()}
          className="py-8 px-12 bg-indigo-400 text-black rounded-lg shadow-md hover:bg-indigo-200"
        >
          <p className="text-xl text-slate-800">Generar ZIP</p>
          <p className="text-sm text-slate-600">Licitaciones</p>

          <input
            id="generarIAZipFile"
            type="file"
            style={{ display: "none" }}
            onChange={handleGenerarZipFileChange}
          />
        </button>
      </div>

      {loading && <LoadingSpinner />}
    </section>
  );
}
