"use client";
import React, { useState } from "react";
import { FcBusinessman, FcLock } from "react-icons/fc";
import Alert from "../app/components/alert";
import Image from "next/image";
import { useSession } from "./contexts/SessionContext";
import { useRouter } from "next/navigation";

const Index = () => {
  // Estado para manejar los valores de usuario y contraseña
  const { login, error } = useSession();
  const [usuario, setUsuario] = useState("");
  const [contrasena, setContrasena] = useState("");

  const router = useRouter();

  // Función para manejar el envío del formulario
  const handleSubmit = async (event) => {
    event.preventDefault();

    try {
      const userData = await login(usuario, contrasena);
      if (
        userData.usuario.permisos_usuarios.nombre_permisos ===
        "ADMINISTRADOR"
      ) {
        router.push("/admin/dashboard");
      } else {
        router.push("/dashboard");
      }
    } catch (error) {
      if (error.response && error.response.status === 404) {
        setError("Usuario no encontrado");
      } else {
        setError("Error en la solicitud");
      }
    }
  };

  return (
    <div className="flex h-screen">
      {/* Mitad Izquierda: Formulario de Inicio de Sesión */}
      <div className="flex-1 flex flex-col justify-center items-center shadow-2xl bg-[#550CF2]">
        {/* Encabezado con el título y el logotipo */}
        <div className="bg-[#550CF2] text-white p-4 flex items-center">
          <Image
            src="/assets/LOGO.png"
            alt="Venturix Logo"
            className="mr-2 logo"
            width={120}
            height={120}
          />
          <h1 className="text-5xl font-bold">Venturix</h1>
        </div>

        {/* Formulario de Inicio de Sesión */}
        <form
          onSubmit={handleSubmit}
          className="w-full max-w-md bg-[#0A12A6] p-8 rounded shadow-2xl"
        >
          <h2 className="text-2xl mb-6 text-white">Iniciar Sesión</h2>
          <div className="mb-4">
            <label
              htmlFor="usuario"
              className="block text-white text-sm font-bold mb-2"
            >
              Correo
            </label>
            <div className="relative">
              <input
                type="text"
                id="usuario"
                className="w-full py-2 px-3 border text-black border-gray-300 rounded focus:outline-none focus:border-blue-500"
                placeholder="Ingresa tu correo"
                value={usuario}
                onChange={(e) => setUsuario(e.target.value)}
              />
              <div className="absolute inset-y-0 right-0 flex items-center pr-3">
                <FcBusinessman className="text-gray-500" />
              </div>
            </div>
          </div>
          <div className="mb-4">
            <label
              htmlFor="contrasena"
              className="block text-white text-sm font-bold mb-2"
            >
              Contraseña
            </label>
            <div className="relative">
              <input
                type="password"
                id="contrasena"
                className="w-full py-2 px-3 border text-black border-gray-300 rounded focus:outline-none focus:border-blue-500"
                placeholder="Ingresa tu contraseña"
                value={contrasena}
                onChange={(e) => setContrasena(e.target.value)}
              />
              <div className="absolute inset-y-0 right-0 flex items-center pr-3">
                <FcLock className="text-gray-500" />
              </div>
            </div>
          </div>

          <button
            type="submit"
            className="bg-blue-500 text-white py-2 px-4 rounded hover:bg-blue-800 focus:outline-none focus:shadow-outline-blue"
          >
            Ingresar
          </button>
          {/* Toast de inicio de sesión incorrecto */}
          {error && (
            <Alert
              onClose={() => setError(false)}
              type="danger"
              className={"mt-2"}
            >
              Usuario o contraseña incorrectos
            </Alert>
          )}
        </form>
      </div>

      {/* Mitad Derecha: Video de Fondo */}
      <div className="flex-1 hidden md:block">
        <video autoPlay loop muted className="w-full h-full object-cover">
          <source src="/assets/FondoAnimado.mp4" type="video/mp4" />
          Tu navegador no soporta el elemento de video.
        </video>
      </div>
    </div>
  );
};

export default Index;
