"use client";
import React, { useState, useEffect } from "react";
import PostulationCard from "../../components/PostulationCard";
import axios from "axios";
import {  IoMdDownload, IoMdArrowUp } from "react-icons/io";
import { IoDocumentAttachOutline } from "react-icons/io5";
import Card from "../../components/card";
import { DocumentIcon } from "@heroicons/react/24/solid";

const Postulaciones = () => {
  const handlePostularTodo = () => {
    console.log("Postular a todo");
  };

  const [errorNulo, setErrorNulo] = useState(null);

  const handleDescargarTodo = async () => {};

  const handleSubirExcel = () => {
    setMostrarFormulario(true);
  };

  const handleCloseFormulario = () => {
    setMostrarFormulario(false);
  };
  // Nuevo estado para manejar la información del archivo subido
  const [archivoSubido, setArchivoSubido] = useState(null);
  // Función para manejar eventos de arrastrar y soltar
  const handleDragOver = (e) => {
    e.preventDefault();
  };

  const handleDrop = (e) => {
    e.preventDefault();

    const file = e.dataTransfer.files[0];

    // Validar si el archivo es un formato Excel (.xlsx)
    if (file && file.name.toLowerCase().endsWith(".xlsx")) {
      setArchivoSubido(file);
      setErrorNulo(null); // Limpiar el mensaje de error
    } else {
      setArchivoSubido(null);
      setErrorNulo(
        "Por favor, seleccione un archivo Excel válido con extensión .xlsx."
      );
      alert(
        "Por favor, seleccione un archivo Excel válido con extensión .xlsx."
      );
    }
  };
  // Función para manejar el cambio de archivo

  const handleFileChange = (e) => {
    const file =
      e.target.files[0] || (e.dataTransfer && e.dataTransfer.files[0]);

    // Validar si el archivo es un formato Excel (.xlsx)
    if (file && file.name.toLowerCase().endsWith(".xlsx")) {
      setArchivoSubido(file);
      setErrorNulo(null); // Limpiar el mensaje de error
    } else {
      setArchivoSubido(null);
      setErrorNulo(
        "Por favor, seleccione un archivo Excel válido con extensión .xlsx."
      );
      alert(
        "Por favor, seleccione un archivo Excel válido con extensión .xlsx."
      );
    }
  };

  // Función para manejar la modificación del archivo
  const handleModificar = (archivo) => {
    console.log("Modificar archivo:", archivo);
    // Implementar la lógica de modificación según tus necesidades
  };

  // Función para manejar la eliminación del archivo
  const handleEliminar = () => {
    console.log("Eliminar archivo");
    // Implementar la lógica de eliminación según tus necesidades
    setArchivoSubido(null); // Limpiar el estado después de eliminar
  };

  const estiloConImagen = {
    backgroundImage: 'url("/assets/Fondo.jpg")',
    backgroundSize: "cover",
    backgroundRepeat: "no-repeat",
  };

  const [datosTarjetas, setDatosTarjetas] = useState([]);
  const [mostrarFormulario, setMostrarFormulario] = useState(false);
  const [factor, setFactor] = useState("10"); // Nuevo estado para el factor

  const tarjetasPorPagina = 5;
  const [paginaActual, setPaginaActual] = useState(1);
  const indiceInicial = (paginaActual - 1) * tarjetasPorPagina;
  const indiceFinal = paginaActual * tarjetasPorPagina;
  const tarjetasEnPagina = datosTarjetas.slice(indiceInicial, indiceFinal);
  const cambiarPagina = (nuevaPagina) => {
    setPaginaActual(nuevaPagina);
  };

  useEffect(() => {
    // Realizar la solicitud HTTP al back-end
    axios
      .get(process.env.API_URL+"/licitaciones/?skip=0&limit=10")
      .then((response) => {
        console.log(response.data);
        // Actualizar el estado con los datos recibidos
        setDatosTarjetas(response.data);
      })
      .catch((error) => {
        console.error("Error al obtener datos del back-end:", error);
      });
  }, []);

  return (
    <section>
      <div className="flex" onDragOver={handleDragOver} onDrop={handleDrop}>
        <div className="flex-1">
          <div className="mt-4">
            <div className="max-w-sm md:max-w-md lg:max-w-lg xl:max-w-xl">
              <h1 className="text-3xl font-bold text-black border-b border-black pb-2 mb-3 flex items-center">
                <DocumentIcon className="mr-2 h-8 w-8" /> Postulaciones
              </h1>
            </div>
          </div>

          <div className="flex justify-end px-">

          <div className="md:flex items-center">
            {/* Botones originales */}

            <button
              className="bg-red-500 hover:bg-red-700 text-white font-bold py-2 px-4 rounded mt-2 flex items-center"
              onClick={handleDescargarTodo}
            >
              <IoMdDownload className="mr-2" size={20} />
              Descargar todo
            </button>

          </div>

          </div>
          
          <div className="grid grid-cols-1 gap-4 mt-4">
          {tarjetasEnPagina.map((data, index) => (
            <PostulationCard key={index} data={data} />
          ))}
          </div>


          <div className="flex justify-center mt-4 mb-4">
            <button
              className={`mx-1 px-3 py-1 rounded-md ${
                paginaActual === 1 ? " cursor-not-allowed" : "bg-blue-400"
              }`}
              onClick={() => {
                if (paginaActual > 1) {
                  cambiarPagina(1);
                }
              }}
              disabled={paginaActual === 1}
            >
              {"<<"}
            </button>
            {Array.from(
              { length: Math.ceil(datosTarjetas.length / tarjetasPorPagina) },
              (_, i) => (
                <button
                  key={i}
                  className={`mx-1 px-3 py-1 rounded-full ${
                    paginaActual === i + 1 ? "bg-blue-500 text-white" : ""
                  }`}
                  onClick={() => cambiarPagina(i + 1)}
                >
                  {i + 1}
                </button>
              )
            )}
            <button
              className={`mx-1 px-3 py-1 rounded-md ${
                paginaActual ===
                Math.ceil(datosTarjetas.length / tarjetasPorPagina)
                  ? " cursor-not-allowed"
                  : "bg-blue-400"
              }`}
              onClick={() => {
                if (
                  paginaActual <
                  Math.ceil(datosTarjetas.length / tarjetasPorPagina)
                ) {
                  cambiarPagina(
                    Math.ceil(datosTarjetas.length / tarjetasPorPagina)
                  );
                }
              }}
              disabled={
                paginaActual ===
                Math.ceil(datosTarjetas.length / tarjetasPorPagina)
              }
            >
            </button>
          
          </div>

                    {/* Mostrar formulario si mostrarFormulario es true */}
                    {mostrarFormulario && (
            <div className="fixed inset-0 bg-gray-500 bg-opacity-75 flex items-center justify-center">
              <div
                className="bg-white p-4 rounded-md relative"
                style={{ background: "#07338C" }}
              >
                <h2 className="text-xl text-white font-bold mb-4 flex items-center">
                  <IoMdArrowUp className="mr-2" size={20} />
                  Subir Excel
                </h2>
                {/* Formulario con campos para arrastrar/subir el archivo Excel y el número "Factor" */}
                <form className="relative">
                  <div className="mb-4">
                    <label
                      htmlFor="factor"
                      className="block text-sm font-medium text-white"
                    >
                      Factor:
                    </label>
                    <select
                      id="factor"
                      name="factor"
                      className="mt-1 p-2 border rounded-md text-black"
                      value={factor}
                      onChange={(e) => setFactor(e.target.value)}
                    >
                      <option value="10">10</option>
                      <option value="20">20</option>
                      <option value="30">30</option>
                      <option value="40">40</option>
                    </select>
                  </div>
                  <div className="mb-4">
                    <label
                      htmlFor="excelFile"
                      className="block text-sm font-medium text-white"
                    >
                      Arrastra o sube tu archivo Excel aquí:
                    </label>
                    <div
                      className="mt-1 p-2 border rounded-md"
                      style={{ background: "white" }}
                    >
                      <input
                        type="file"
                        id="excelFile"
                        name="excelFile"
                        className="hidden"
                        onChange={(e) => handleFileChange(e)}
                      />
                      <div className="text-center">
                        <label
                          htmlFor="excelFile"
                          className="cursor-pointer text-blue-500 hover:underline"
                        >
                          {archivoSubido
                            ? "Cambiar archivo"
                            : "Seleccionar archivo"}
                        </label>
                        {archivoSubido && (
                          <div className="mt-2 text-black">
                            <p>{archivoSubido.name}</p>
                            <div className="flex mt-1">
                              <div className="mx-auto">
                                <button
                                  className="bg-red-500 hover:bg-red-700 text-white font-bold py-1 px-2 rounded"
                                  onClick={handleEliminar}
                                >
                                  Eliminar
                                </button>
                              </div>
                            </div>
                          </div>
                        )}
                      </div>
                    </div>
                  </div>
                  <button
                    type="submit"
                    className="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded mr-2"
                  >
                    Enviar
                  </button>
                  {/* Botón para cerrar el formulario */}
                  <button
                    className="absolute bottom-0 right-0 bg-red-500 hover:bg-red-700 text-white font-bold py-2 px-4 rounded mb-0 "
                    onClick={handleCloseFormulario}
                  >
                    Cerrar
                  </button>
                </form>
              </div>
            </div>
          )}

        </div>
      </div>
    </section>
  );
};

export default Postulaciones;
