/** @type {import('tailwindcss').Config} */

const colors = require('tailwindcss/colors')

module.exports = {
  content: [
    './src/pages/**/*.{js,ts,jsx,tsx,mdx}',
    './src/components/**/*.{js,ts,jsx,tsx,mdx}',
    './src/app/**/*.{js,ts,jsx,tsx,mdx}',
  ],
  theme: {
    extend: {
      backgroundImage: {
        'gradient-radial': 'radial-gradient(var(--tw-gradient-stops))',
        'gradient-conic':
          'conic-gradient(from 180deg at 50% 50%, var(--tw-gradient-stops))',
      },
    },
    colors: {
        ...colors,
        "vCreamBlue": {
          50: "#EDECFE",
          100: "#DBD8FD",
          200: "#B8B2FB",
          300: "#9890F9",
          400: "#7569F7",
          500: "#5142F5",
          600: "#1F0DED",
          700: "#180AB3",
          800: "#0F0674",
          900: "#08033A",
          950: "#04021D"
        },
        "vDarkBlue": {
          50: "#E1F3FA",
          100: "#C2E8F4",
          200: "#81CFE9",
          300: "#45B8DE",
          400: "#2091B6",
          500: "#155F77",
          600: "#114C5F",
          700: "#0D3B4A",
          800: "#082630",
          900: "#05151A",
          950: "#020A0D"
        },
        "vPurple": {
          50: "#F1E3FC",
          100: "#E3C7FA",
          200: "#C993F5",
          300: "#AD5BF0",
          400: "#9328EB",
          500: "#7612C6",
          600: "#5E0E9F",
          700: "#450B75",
          800: "#2F074F",
          900: "#160325",
          950: "#0B0213"
        },
        "vPink": {
          50: "#FEE7FC",
          100: "#FCCAF8",
          200: "#F995F0",
          300: "#F660E9",
          400: "#F22BE2",
          500: "#DB0DCB",
          600: "#AD0AA0",
          700: "#820878",
          800: "#570550",
          900: "#2B0328",
          950: "#180116"
        }
      }
  },
  plugins: [
    require('@tailwindcss/typography'),
    // ...
  ],
}
