import { API_URL } from '@/app/const'

export async function getEmpresas(token) {

  try {
    const response = await fetch(API_URL+'/empresas/', {
      headers: {
        Authorization: `Bearer ${token}`, // Usa el token de autenticación del usuario
      },
    });

    if (!response.ok) {
      throw new Error('Error al obtener las empresas');
    }

    const data = await response.json();
    return data;
  } catch (error) {
    console.error('Error al obtener las empresas:', error.message);
    throw error;
  }
}

export async function getEmpresa(id, token) {

  try {
    const response = await fetch(API_URL+'/empresas/'+id, {
      headers: {
        Authorization: `Bearer ${token}`, // Usa el token de autenticación del usuario
      },
    });

    if (!response.ok) {
      throw new Error('Error al obtener las empresas');
    }

    const data = await response.json();
    return data;
  } catch (error) {
    console.error('Error al obtener las empresas:', error.message);
    throw error;
  }
}