import { API_URL } from "@/app/const"

export async function login(username, password) {
  try {
    const response = await fetch( API_URL+"/usuarios/login", {
      method: "POST",
      headers: {
        "Content-Type": "application/json",
      },
      body: JSON.stringify({ usr_email: username, password: password }),
    });

    if (!response.ok) {
      throw new Error("Error al iniciar sesión");
    }

    const data = await response.json();
    return data;
  } catch (error) {
    console.error("Error al iniciar sesión:", error.message);
    throw error;
  }
}
