import React from "react";

const UserDatos = ({ label, value }) => {
  return (
    <div className="flex items-center mb-4">
      <label className="mr-2 font-bold">{label}:</label>
      {Array.isArray(value) ? (
        <ul>
          {value.map((item) => (
            <li key={item.id}>{item.nombre}</li>
          ))}
        </ul>
      ) : (
        <p className="w-96">{value}</p>
      )}
    </div>
  );
};

const ModalDetalles = React.memo(({ usuario, onClose, isOpen, accion }) => {
  console.log("isOpen recibido:", isOpen);
  const closeModal = () => {
    onClose();
  };

  return (
    <form className="overflow-auto">
      <div className="text-black w-1/2 border-b border-black mb-4">
        <h2 className="text-black text-xl font-bold mb-[1px] ml-1">
          Datos del Usuario
        </h2>
      </div>
      <div className="text-black px-2 py-1">
        <UserDatos label="Nombre" value={usuario.nombre_usuario} />
        <UserDatos label="RUT" value={usuario.rut_usuario} />
        <UserDatos label="Correo Electrónico" value={usuario.correo_usuario} />
        <UserDatos label="Teléfono" value={usuario.telefono_usuario} />
        {usuario.permisos_usuarios && usuario.permisos_usuarios.length > 0 && (
          <UserDatos
            label="Permisos"
            value={usuario.permisos_usuarios
              .map((permiso) => permiso.nombre_permisos)
              .join(", ")}
          />
        )}
      </div>
      <div className="mt-2 text-right">
        <button
          className="bg-gray-500 hover:bg-gray-600 text-white px-4 py-2 rounded-lg"
          onClick={closeModal}
        >
          Cancelar
        </button>
      </div>
    </form>
  );
});

ModalDetalles.displayName = "ModalDetalles";

export default ModalDetalles;
