import React, { useState } from "react";

const ModalEliminar = ({ usuario, onClose, onConfirm, isOpen }) => {
  console.log("isOpen recibido:", isOpen);
  console.log("usuario recibido:", usuario);
  const closeModal = () => {
    onClose(); // Llamada a la función onClose del padre
  };
  const confirmAction = () => {
    // Llamada a la función onConfirm del padre
    onConfirm("eliminar", usuario);
    closeModal();
  };

  return (
    <form className="overflow-auto">
      <div className="text-black w-1/2 border-b border-black mb-4">
        <h2 className="text-black text-xl font-bold mb-[1px] ml-1">
          Eliminar Usuario
        </h2>
      </div>
      <div className="text-black px-4 py-2">
        <p>{`¿Está seguro que desea eliminar al usuario ${usuario?.nombre_usuario}?`}</p>
      </div>
      <div className="mt-4 text-right">
        <button
          className="bg-red-600 hover:bg-red-700 text-white px-4 py-2 rounded-lg mr-2"
          onClick={confirmAction}
        >
          Eliminar
        </button>
        <button
          className="bg-gray-500 hover:bg-gray-600 text-white px-4 py-2 rounded-lg"
          onClick={onClose}
        >
          Cancelar
        </button>
      </div>
    </form>
  );
};

export default ModalEliminar;
