import React, { useState } from 'react';
import Image from 'next/image';
import Link from 'next/link';

const CustomLink = ({ href, children, backgroundImage }) => {
  const [isHovered, setIsHovered] = useState(false);

  const linkStyle = {
    position: 'relative',
    borderRadius: '8px',
    overflow: 'hidden',
  };

  const imageStyle = {
    width: '150%',
    height: '150%',
    minWidth: '150%', // Añade esta línea para forzar el aumento del tamaño
    objectFit: 'cover',
    transition: 'filter 0.3s ease',
    filter: isHovered ? 'blur(8px)' : 'none',
  };

  const contentStyle = {
    position: 'absolute',
    top: '50%',
    left: '50%',
    transform: 'translate(-50%, -50%)',
    textAlign: 'center',
    color: '#fff',
    zIndex: 1,
  };

  return (
    <Link href={href}>
      <div className="mb-4 ml-4 mr-4" style={linkStyle}>
        <div
          className={`rounded-md p-4 sm:p-8 flex items-center justify-center shadow-lg w-48 h-48 ${
            isHovered ? 'filter brightness-90' : ''
          }`}
          onMouseEnter={() => setIsHovered(true)}
          onMouseLeave={() => setIsHovered(false)}
        >
          <div style={imageStyle}>
            <Image src={backgroundImage} alt="Background" style={{ width: '100%', height: '100%' }} />
          </div>
          <div style={contentStyle}>{children}</div>
        </div>
      </div>
    </Link>
  );
};

export default CustomLink;
