"use client"
import React, { useEffect, useState } from 'react';

import Card from '../../components/card';
import { CubeIcon, EyeIcon } from '@heroicons/react/24/solid'

export default function OrdenesCompra(){ 

  const [ordenesCompra, setOrdenesCompra] = useState([]);
  const CodigoProveedor = 1850423;

  useEffect(() => {
    fetch('https://api.mercadopublico.cl/servicios/v1/publico/ordenesdecompra.json?estado=enviadaproveedor&CodigoProveedor=1850423&ticket=F8537A18-6766-4DEF-9E59-426B4FEE2844')
      .then(response => response.json())
      .then(data => setOrdenesCompra(data.Listado))
      .catch(error => console.error('Error fetching data:', error));
  }, []); 


    return (
          <div>
            <div className="rounded-md py-4 max-w-sm md:max-w-md lg:max-w-lg xl:max-w-xl">
              <h1 className="flex items-center text-3xl font-bold text-black border-b border-black pb-2">
                <CubeIcon className='h-8 w-8 mr-2'/>
                Ordenes de Compra
              </h1>
            </div>

            <div className='grid grid-cols-2 gap-4'>

      {/* Render a Card for each item in the data array */}
            {ordenesCompra?.map(item => (
              <Card key={item.Codigo}>

                <p className='text-slate-600 text-sm'>{item.Codigo}</p>
                <strong className='text-lg text-gray-800'>{item.Nombre}</strong>

                <div className='flex justify-between items-end text-gray-800'>
                    
                    <div className='bg-green-400 border border-green-600 rounded-md text-sm p-1'>
                      Enviada a proveedor
                    </div>
                    <button className='text-white rounded-sm border-blue-700 bg-blue-600 hover:bg-blue-400 p-2'>
                      <EyeIcon className='w-6 h-6'/>
                    </button>
                  </div>                
              </Card>
            ))}
            </div>
              

          </div>
    );
};