"use client";
import React from "react";
import Card from "../components/card";
import CountUp from "react-countup";
import {
  HomeIcon,
  ChartBarIcon,
  CheckCircleIcon,
  XCircleIcon,
} from "@heroicons/react/24/solid";

export default function Home() {
  return (
    <div>
      <div className="rounded-md py-4 max-w-sm md:max-w-md lg:max-w-lg xl:max-w-xl">
        <h1 className="flex items-center text-3xl font-bold text-black border-b border-black pb-2">
          <HomeIcon className="h-8 w-8 mr-2" />
          Inicio
        </h1>
      </div>

      <div className="grid grid-cols-2 gap-4">
        <Card>
          <div className="flex justify-between items-center">
            <h1 className="flex items-center text-3xl font-bold text-black pb-2 gap-2">
              <ChartBarIcon className="h-6 w-6" />
              Resumen del día
            </h1>

            <p className="text-gray-400">25-01-2024</p>
          </div>

          <div className="text-lg ml-8">
            <p className="text-black flex gap-2">
              <CheckCircleIcon className="w-6 h-6 text-green-500" />
              <CountUp end="100" delay={1} duration={3} /> Postulaciones
              exitosas
            </p>

            <p className="text-black flex gap-2">
              <XCircleIcon className="w-6 h-6 text-red-500" />
              <CountUp end="5" delay={1} duration={3} /> Postulaciones fallidas
            </p>
          </div>
        </Card>

        <Card>
          <div className="flex justify-between items-center">
            <h1 className="flex items-center text-3xl font-bold text-black pb-2 gap-2">
              <ChartBarIcon className="h-6 w-6" />
              Resumen del mes
            </h1>

            <p className="text-gray-400">Enero</p>
          </div>

          <div className="text-lg ml-8">
            <p className="text-black flex gap-2">
              <CheckCircleIcon className="w-6 h-6 text-green-500" />
              <CountUp end="2500" delay={1} duration={3} /> Postulaciones
              exitosas
            </p>

            <p className="text-black flex gap-2">
              <XCircleIcon className="w-6 h-6 text-red-500" />
              <CountUp end="200" delay={1} duration={3} /> Postulaciones
              fallidas
            </p>
          </div>
        </Card>
      </div>
    </div>
  );
}
